<?php

namespace Digits\SocialLogin\Auths;

use DigitsSocialOAuth2;

class AtlassianAuth extends SocialLoginAuth
{
    private $client_id;
    private $redirect_url;
    private $icon_only;
    private $settings;

    function __construct($settings, $social_info, $icon_only)
    {
        $this->settings = $settings;
        $this->client_id = esc_attr($settings['clientID']);
        $this->redirect_url = $social_info['redirect_uri'];
        $this->icon_only = $icon_only;


        parent::__construct();

    }

    public function render()
    {
        $this->default_layout('digits_atlassian_login', 'Atlassian');
    }

    public function get_url()
    {
        $query = [
            'audience' => urlencode('api.atlassian.com'),
            'client_id' => urlencode($this->client_id),
            'response_type' => 'code',
            'scope' => 'read%3Ame',
            'redirect_uri' => urlencode($this->redirect_url),
            'state' => wp_create_nonce('atlassian_login'),
        ];


        $base_url = 'https://auth.atlassian.com/authorize';
        return add_query_arg($query, $base_url);
    }

    public function enqueue_scripts()
    {
    }

    public function process_token()
    {
    }

    public function process_oauth_token()
    {
        if (empty($_REQUEST['code'])) {
            $this->invalid_info();
            die();
        }
        if (!wp_verify_nonce($_REQUEST['state'], 'atlassian_login')) {
            $this->nonce_fail();
            die();
        }
        try {
            $code = $_REQUEST['code'];
            $accessTokenUrl = 'https://auth.atlassian.com/oauth/token';

            $client = new DigitsSocialOAuth2\Client($this->client_id, $this->settings['clientSecretID'], DigitsSocialOAuth2\Client::AUTH_TYPE_AUTHORIZATION_BASIC);

            $params = array("code" => $code, "redirect_uri" => $this->redirect_url);
            $response = $client->getAccessToken($accessTokenUrl, "authorization_code", $params);
            $accessTokenResult = $response["result"];

            if (empty($accessTokenResult["access_token"])) {
                $this->invalid_info();
                die();
            }

            $client->setAccessToken($accessTokenResult["access_token"]);
            $client->setAccessTokenType(DigitsSocialOAuth2\Client::ACCESS_TOKEN_BEARER);

            $response = $client->fetch("https://api.atlassian.com/me");
            $response = $response['result'];

            $name = $response['name'];
            $username = $response['username'];
            $id = $response['account_id'];

            $email = '';
            if ($response['email_verified'] == 1) {
                $email = $response['email'];
            }

            $response = digits_social_create_user($name, $email, 'atlassian', $username, $id);

            $this->success_view($response);
        } catch (\Exception $e) {
            $this->error_view($e);
        }
    }
}
